﻿namespace Code6587EN.Ch02.NewDeviceChannel
{    
    using System;
    using Microsoft.SharePoint;

    /// <summary>
    /// Console Application to create a new Composed Look 
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection containing the Site with the URL of the Site in a Using statement.            
            using (var site = new SPSite("http://sharepoint/site"))
            {
                // Open the Site in a Using statement.  Using OpenWeb() will open the Site that is specified 
                // in the URL when opening the Site Collection.
                using (var web = site.OpenWeb())
                {
                    // Get the Composed Looks list from the Site
                    var list = web.Lists["Composed Looks"];

                    // Add a new item to the Composed Looks list
                    var item = list.Items.Add();

                    // Add the item properties.  \n is an escape character in C# for a line break.
                    item["Name"] = "Code";
                    item["Alias"] = "Code ";
                    item["Description"] = "Code Channel";
                    item["Device Inclusion Rules"] = "Android\niPad\niPod\niPhone\nBlackBerry\nIEMobile\nWebOS";
                    item["Active"] = true;

                    // Update the new item with the newly added properties.
                    item.Update();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
